<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Papers</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <style>
        .paper-cover {
            height: 240px;
            width: 100%;
            object-fit: cover;
        }
        .paper-card {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <header class="d-flex flex-wrap justify-content-center py-3 mb-4 border-bottom" style="background: #fafafa;">
    <div class="container" style="display: flex;">
      <a href="#" class="d-flex align-items-center mb-3 mb-md-0 me-md-auto link-body-emphasis text-decoration-none">
        <svg class="bi me-2" width="40" height="32"><use xlink:href="#bootstrap"></use></svg>
        <span class="fs-4"><img src="https://oruvan.com/_next/image?url=%2F_next%2Fstatic%2Fmedia%2FLogo_Black.94741f0b.webp&w=1920&q=75" style="max-width: 120px;" > E-Papers</span>
      </a>

      <ul class="nav nav-pills">
        <li><a href="https://oruvan.com/" style="text-decoration: none !important;">
        <svg xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" width="28" height="28">
            <path d="M20.084 20.999H14.7C14.203 20.999 13.8 20.596 13.8 20.099V16.237C13.8 15.834 13.47 15.504 13.067 15.504H10.92C10.522 15.504 10.2 15.826 10.2 16.224V20.083C10.2 20.587 9.788 20.999 9.284 20.999H3.9C3.405 20.999 3 20.594 3 20.099V11.48C3 11.126 3.148 10.789 3.409 10.55L11.398 3.234C11.739 2.922 12.261 2.922 12.602 3.234L20.591 10.55C20.852 10.789 21 11.126 21 11.48V20.084C21 20.587 20.588 20.999 20.084 20.999Z" fill="#2B2B2B"></path></svg>
            <span style="color: #333;  font-size:22px; font-weight:600">முகப்பு</span></a></li>

      
    </ul>
      </div>
    </header>
  
    <div class="container mt-5">
       <!--<h1 class="mb-4 text-center">E-Papers</h1>-->
        <div id="epapersContainer" class="row row-cols-1 row-cols-md-5 g-4 "></div>
        <nav id="paginationNav" class="mt-4">
            <ul class="pagination justify-content-center"></ul>
        </nav>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.0/dist/jquery.min.js"></script>
    <script>
        const coverPlaceholder = 'cover.png';
        const fetchPapers = (page = 1) => {
            $.ajax({
                url: 'get_epapers.php',
                type: 'GET',
                data: { page },
                dataType: 'json',
                success: function (response) {
                    const { papers, totalPages } = response;

                    // Clear container
                    $('#epapersContainer').empty();

                    // Populate papers
                    papers.forEach(paper => {
                        const coverPath = `${paper.img_url}`;
                        const paperCard = `
                            <div class="col paper-card ">
                                <div class="card h-100 shadow">
                                <a href="ebook.php?bid=${paper.p_id}">
                                    <img src="${coverPath}" class="card-img-top paper-cover" alt="${paper.p_name}" >
                                    </a>
                                    <div class="card-body">
                                        <h5 class="card-title">${paper.p_name}</h5>
                                        <p class="card-text">${new Date(paper.p_date).toLocaleDateString()}</p>
                                    </div>
                                </div>
                            </div>
                        `;
                        $('#epapersContainer').append(paperCard);
                    });

                    // Setup pagination
                        const pagination = $('.pagination');
                        pagination.empty();

                        for (let i = 1; i <= totalPages; i++) {
                            pagination.append(`
                                <li class="page-item ${i === page ? 'active' : ''}">
                                    <button class="page-link" data-page="${i}">${i}</button>
                                </li>
                            `);
                        }

                        // Unbind previous click events and bind new ones
                        pagination.find('button').off('click').on('click', function () {
                            const newPage = $(this).data('page');
                            fetchPapers(newPage);
                        });

                },
                error: function () {
                    $('#epapersContainer').html('<p class="text-center text-danger">Failed to load papers. Please try again.</p>');
                }
            });
        };

        // Initial fetch
        fetchPapers();
    </script>
</body>
</html>
