<?php
include("config.inc.php");
if(isset($_SESSION['user']) && $_SESSION['user'] == $admin_user){
	//
} else {
	header("location:login.php");
	exit;
}
include("header.php");
?>
<style>
        #progressWrapper {
            display: none;
            margin-top: 20px;
        }

        #loader {
            display: none;
            margin-top: 10px;
            text-align: center;
        }
    </style>

    <div class="container mt-5">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">E-Paper Submission Form</h4>
            </div>
            <div class="card-body">
            <form id="ePaperForm" enctype="multipart/form-data">
    <div class="mb-3">
        <label for="p_name" class="form-label">Title:</label>
        <input type="text" name="p_name" id="p_name" class="form-control" placeholder="Enter title" required>
    </div>
    <div class="mb-3">
        <label for="p_date" class="form-label">Date:</label>
        <input type="date" name="p_date" id="p_date" class="form-control" required>
    </div>
    <div class="mb-3">
        <label for="p_type" class="form-label">Type:</label>
        <select name="p_type" id="p_type" class="form-select" required>
            <option value="Daily">Daily</option>
            <option value="Weekly">Weekly</option>
        </select>
    </div>
    <div class="mb-3">
        <label for="p_status" class="form-label">Status:</label>
        <select name="p_status" id="p_status" class="form-select" required>
            <option value="Published">Published</option>
            <option value="Private">Private</option>
        </select>
    </div>
    <div class="mb-3">
        <label for="p_path" class="form-label">PDF File:</label>
        <input type="file" name="p_path" id="p_path" class="form-control" accept="application/pdf" required>
       <!-- <small class="text-muted">Only PDF files (max 50MB).</small>-->
    </div>
    <div class="mb-3">
        <label for="cover_photo" class="form-label">Cover Photo:</label>
        <input type="file" name="cover_photo" id="cover_photo" class="form-control" accept="image/jpeg, image/png">
        <small class="text-muted">Only JPG or PNG files (max 2MB).</small>
    </div>
    <button type="submit" class="btn btn-success w-100">Submit</button>
</form>

<!-- Progress Wrapper -->
<div id="progressWrapper" class="mt-4">
            <div class="progress">
                <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%;">0%</div>
            </div>
        </div>

        <!-- Loader -->
        <div id="loader">
            <div class="spinner-border text-success" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
        <!-- Result -->
        <div id="resultMessage" class="mt-3"></div>
            </div>
        </div>
    </div>


    <script>
        $(document).ready(function () {
            $('#ePaperForm').on('submit', function (e) {
                e.preventDefault();

                // Show progress bar and loader
                $('#progressWrapper').show();
                $('#loader').show();
                $('#progressBar').css('width', '0%').text('0%');
                $('#resultMessage').text('');

                // Prepare form data
                let formData = new FormData(this);

                // AJAX file upload
                $.ajax({
                    url: 'insert_epaper.php',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhr: function () {
                        let xhr = new window.XMLHttpRequest();
                        xhr.upload.addEventListener('progress', function (e) {
                            if (e.lengthComputable) {
                                let percentComplete = Math.round((e.loaded / e.total) * 100);
                                $('#progressBar').css('width', percentComplete + '%').text(percentComplete + '%');
                            }
                        });
                        return xhr;
                    },
                    success: function (response) {
                        $('#resultMessage').html('<div class="alert alert-success">' + response + '</div>');
                        $('#progressWrapper').hide();
                        $('#loader').hide();
                    },
                    error: function () {
                        $('#resultMessage').html('<div class="alert alert-danger">Failed to upload. Please try again.</div>');
                        $('#progressWrapper').hide();
                        $('#loader').hide();
                    }
                });
            });
        });
    </script>
<?php
include("footer.php");
?>