<?php
include("config.inc.php");
if(isset($_SESSION['user']) && $_SESSION['user'] == $admin_user){
	//
} else {
	header("location:login.php");
	exit;
}
include("header.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $p_id = $_POST['p_id'];
    $p_name = $_POST['p_name'];
    $p_date = $_POST['p_date'];
    $p_type = $_POST['p_type'];
    $p_status = $_POST['p_status'];

    $stmt = $conn->prepare("UPDATE epapers SET p_name=?, p_date=?, p_type=?, p_status=? WHERE p_id=?");
    $stmt->bind_param("ssssi", $p_name, $p_date, $p_type, $p_status, $p_id);
    $stmt->execute();
    $stmt->close();

    header("Location: list-epapers.php");
    exit;
}

$p_id = $_GET['id'];
$result = $conn->query("SELECT * FROM epapers WHERE p_id = $p_id");
$paper = $result->fetch_assoc();
?>
    <div class="container mt-5">
        <h1 class="mb-4">Edit E-Paper</h1>
        <form method="POST" action="">
            <input type="hidden" name="p_id" value="<?php echo $paper['p_id']; ?>">
            <div class="mb-3">
                <label for="p_name" class="form-label">Title</label>
                <input type="text" class="form-control" id="p_name" name="p_name" value="<?php echo htmlspecialchars($paper['p_name']); ?>" required>
            </div>
            <div class="mb-3">
                <label for="p_date" class="form-label">Date</label>
                <input type="date" class="form-control" id="p_date" name="p_date" value="<?php echo $paper['p_date']; ?>" required>
            </div>
            <div class="mb-3">
                <label for="p_type" class="form-label">Type</label>
                <select class="form-select" id="p_type" name="p_type">
                    <option value="Daily" <?php echo $paper['p_type'] === 'Daily' ? 'selected' : ''; ?>>Daily</option>
                    <option value="Weekly" <?php echo $paper['p_type'] === 'Weekly' ? 'selected' : ''; ?>>Weekly</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="p_status" class="form-label">Status</label>
                <select class="form-select" id="p_status" name="p_status">
                    <option value="Published" <?php echo $paper['p_status'] === 'Published' ? 'selected' : ''; ?>>Published</option>
                    <option value="Private" <?php echo $paper['p_status'] === 'Private' ? 'selected' : ''; ?>>Private</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </form>
    </div>
<?php 
$conn->close(); 
include("footer.php");
?>